% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/excel-financial-math-functions.R
\name{excel_financial_math_functions}
\alias{excel_financial_math_functions}
\alias{NPV}
\alias{IRR}
\alias{FV}
\alias{PV}
\alias{PMT}
\alias{RATE}
\title{Excel Financial Math Functions}
\usage{
NPV(cashflow, rate, nper = NULL)

IRR(cashflow)

FV(rate, nper, pv = 0, pmt = 0, type = 0)

PV(rate, nper, fv = 0, pmt = 0, type = 0)

PMT(rate, nper, pv, fv = 0, type = 0)

RATE(nper, pmt, pv, fv = 0, type = 0)
}
\arguments{
\item{cashflow}{Cash flow values. When one value is provided, it's assumed constant cash flow.}

\item{rate}{One or more rate. When one rate is provided it's assumed constant rate.}

\item{nper}{Number of periods. When `nper`` is provided, the cashflow values and rate are assumed constant.}

\item{pv}{Present value. Initial investments (cash inflows) are typically a negative value.}

\item{pmt}{Number of payments per period.}

\item{type}{Should payments (\code{pmt}) occur at the beginning (\code{type = 0}) or
the end (\code{type = 1}) of each period.}

\item{fv}{Future value. Cash outflows are typically a positive value.}
}
\value{
\itemize{
\item Summary functions return a single value
}
}
\description{
\strong{Excel financial math functions} are designed to easily calculate Net Present Value (\code{\link[=NPV]{NPV()}}),
Future Value of cashflow (\code{\link[=FV]{FV()}}), Present Value of future cashflow (\code{\link[=PV]{PV()}}), and more.

These functions are designed to help users coming from an \strong{Excel background}.
Most functions replicate the behavior of Excel:
\itemize{
\item Names are similar to Excel function names
\item By default, missing values are ignored (same as in Excel)
}
}
\details{
\strong{Net Present Value (NPV)}
Net present value (NPV) is the difference between the present value of cash inflows and
the present value of cash outflows over a period of time. NPV is used in capital budgeting
and investment planning to analyze the profitability of a projected investment or project.
For more information, see \href{https://www.investopedia.com/terms/n/npv.asp}{Investopedia NPV}.

\strong{Internal Rate of Return (IRR)}
The internal rate of return (IRR) is a metric used in capital budgeting to estimate the
profitability of potential investments. The internal rate of return is a discount rate
that makes the net present value (NPV) of all cash flows from a particular project equal
to zero. IRR calculations rely on the same formula as NPV does.
For more information, see \href{https://www.investopedia.com/terms/i/irr.asp}{Investopedia IRR}.

\strong{Future Value (FV)}
Future value (FV) is the value of a current asset at a future date based on an assumed
rate of growth. The future value (FV) is important to investors and financial planners
as they use it to estimate how much an investment made today will be worth in the future.
Knowing the future value enables investors to make sound investment decisions based on
their anticipated needs. However, external economic factors, such as inflation, can adversely
affect the future value of the asset by eroding its value.
For more information, see \href{https://www.investopedia.com/terms/f/futurevalue.asp}{Investopedia FV}.

\strong{Present Value (PV)}
Present value (PV) is the current value of a future sum of money or stream of cash flows given a
specified rate of return. Future cash flows are discounted at the discount rate, and the higher
the discount rate, the lower the present value of the future cash flows. Determining the
appropriate discount rate is the key to properly valuing future cash flows, whether they be earnings
or obligations. For more information, see \href{https://www.investopedia.com/terms/p/presentvalue.asp}{Investopedia PV}.

\strong{Payment (PMT)}
The Payment \code{\link[=PMT]{PMT()}} function calculates the payment for a loan based on constant payments and a constant interest rate.

\strong{Rate (RATE)}
Returns the interest rate per period of a loan or an investment.
For example, use 6\%/4 for quarterly payments at 6\% APR.
}
\examples{

NPV(c(-1000, 250, 350, 450, 450), rate = 0.05)

IRR(c(-1000, 250, 350, 450, 450))

FV(rate = 0.05, nper = 5, pv = -100, pmt = 0, type = 0)

PV(rate = 0.05, nper = 5, fv = -100, pmt = 0, type = 0)

PMT(nper = 20, rate = 0.05, pv = -100, fv = 0, type = 0)

RATE(nper = 20, pmt = 8, pv = -100, fv = 0, type = 0)

}
